CREATE TABLE `bank_accounts` (
  `id` int(11) NOT NULL,
  `bank_name` varchar(225) NOT NULL,
  `bank_sube` varchar(225) NOT NULL,
  `bank_hesap` varchar(225) NOT NULL,
  `bank_iban` text DEFAULT NULL,
  `bank_alici` varchar(225) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `blogs` (
  `id` int(11) NOT NULL,
  `blog_title` text COLLATE utf8mb4_bin DEFAULT NULL,
  `blog_image` text CHARACTER SET utf8 DEFAULT NULL,
  `blog_content` text COLLATE utf8mb4_bin DEFAULT NULL,
  `blog_created` text CHARACTER SET utf8 NOT NULL,
  `url` varchar(225) CHARACTER SET utf8 NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=COMPACT;
-- SEPARATOR --
CREATE TABLE `categories` (
  `category_id` int(11) NOT NULL,
  `category_name` text COLLATE utf8mb4_bin NOT NULL,
  `name_lang` text COLLATE utf8mb4_bin NOT NULL,
  `category_line` double NOT NULL,
  `category_type` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '2',
  `category_secret` enum('1','2') COLLATE utf8mb4_bin NOT NULL DEFAULT '2',
  `category_icon` varchar(225) DEFAULT NULL,
  `category_icon_color` varchar(225) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
-- SEPARATOR --
CREATE TABLE `child_panels` (
  `id` int(11) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  `panel_domain` text DEFAULT NULL,
  `panel_currency` text DEFAULT NULL,
  `panel_status` varchar(225) NOT NULL DEFAULT 'pending',
  `panel_price` text DEFAULT NULL,
  `panel_created` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
-- SEPARATOR --
CREATE TABLE `clients` (
  `client_id` int(11) NOT NULL,
  `first_name` varchar(225) DEFAULT NULL,
  `last_name` varchar(225) DEFAULT NULL,
  `email` varchar(225) NOT NULL,
  `username` varchar(225) NOT NULL,
  `password` text NOT NULL,
  `telephone` varchar(225) DEFAULT NULL,
  `balance` double NOT NULL DEFAULT 0,
  `balance_type` enum('1','2') NOT NULL DEFAULT '2',
  `debit_limit` double NOT NULL,
  `spent` double NOT NULL DEFAULT 0,
  `register_date` datetime NOT NULL,
  `login_date` datetime DEFAULT NULL,
  `login_ip` varchar(225) NOT NULL,
  `register_ip` varchar(225) NOT NULL,
  `apikey` text NOT NULL,
  `client_type` enum('1','2') NOT NULL DEFAULT '2' COMMENT '2 -> ON, 1 -> OFF',
  `access` text DEFAULT NULL,
  `lang` varchar(255) NOT NULL DEFAULT 'tr',
  `timezone` double NOT NULL DEFAULT 0,
  `admin_theme` enum('1','2') NOT NULL DEFAULT '1',
  `referral` varchar(225) DEFAULT NULL,
  `referral_code` varchar(225) NOT NULL,
  `refchar` varchar(225) NOT NULL DEFAULT '0',
  `reforder` varchar(225) NOT NULL DEFAULT '0',
  `total_click` varchar(225) NOT NULL DEFAULT '0',
  `sms_verify` int(11) NOT NULL DEFAULT 1,
  `mail_verify` int(11) NOT NULL DEFAULT 1,
  `currency` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `clients` (`client_id`, `first_name`, `last_name`, `email`, `username`, `password`, `telephone`, `balance`, `balance_type`, `debit_limit`, `spent`, `register_date`, `login_date`, `login_ip`, `register_ip`, `apikey`, `client_type`, `access`, `lang`, `timezone`, `admin_theme`, `referral`, `referral_code`, `refchar`, `reforder`, `total_click`, `sms_verify`, `mail_verify`, `currency`) VALUES
(1, 'Admin', 'Admin', 'admin@smmcode.net', 'admin', '9ab9fa7c5b55c4d1bb4f38bf115b5192', '', 0, '2', 0, 0, '2022-07-29 15:02:05', '2022-08-29 22:11:23', '156.211.77.51', '', '48dda52945f5fefaaeabc96569cd2573', '2', '{\"admin_access\":\"1\",\"users\":\"1\",\"orders\":\"1\",\"subscriptions\":\"1\",\"dripfeed\":\"1\",\"tasks\":\"1\",\"services\":\"1\",\"payments\":\"1\",\"tickets\":\"1\",\"reports\":\"1\",\"general_settings\":\"1\",\"pages\":\"1\",\"blog\":\"1\",\"seo\":\"1\",\"menu\":\"1\",\"subject\":\"1\",\"child_panels\":\"1\",\"payments_settings\":\"1\",\"bank_accounts\":\"1\",\"payments_bonus\":\"1\",\"alert_settings\":\"1\",\"providers\":\"1\",\"modules\":\"1\",\"themes\":\"1\",\"language\":\"1\",\"logs\":\"1\",\"update-prices\":\"1\",\"crons\":\"1\",\"provider_logs\":\"1\",\"guard_logs\":\"1\",\"admins\":\"1\",\"bulk\":\"1\",\"kuponlar\":\"1\",\"currency_settings\":\"1\",\"refill\":\"1\"}', 'en', 39600, '2', NULL, 'a14ff', '0', '0', '1', 1, 1, 1);
-- SEPARATOR --
CREATE TABLE `clients_category` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `clients_price` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `service_price` double NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `clients_service` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `client_report` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `action` text NOT NULL,
  `report_ip` varchar(225) NOT NULL,
  `report_date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `crons` (
  `cron_id` int(11) NOT NULL,
  `cron_name` varchar(50) NOT NULL,
  `cron_operation` varchar(200) NOT NULL,
  `cron_updefault` int(11) NOT NULL DEFAULT 1,
  `cron_endup` int(11) NOT NULL,
  `cron_date_update` timestamp NOT NULL DEFAULT current_timestamp(),
  `cron_status` int(1) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `crons` (`cron_id`, `cron_name`, `cron_operation`, `cron_updefault`, `cron_endup`, `cron_date_update`, `cron_status`) VALUES
(1, 'Api Orders', 'API Order', 1, 1, '2022-07-22 17:50:02', 1),
(3, 'DripFeed', 'Order Control', 1, 1, '2022-07-22 17:50:02', 1),
(4, 'Sync', 'API Provider Control', 1, 1, '2022-07-22 17:50:25', 1),
(5, 'Providers', 'Provider', 1, 1, '2022-07-22 17:50:37', 1),
(6, 'Send Task', 'Posting a Task', 1, 1, '2022-07-22 17:50:37', 1),
(7, 'Balance Alert', 'Balance alert', 15, 15, '2022-07-22 17:50:38', 1),
(8, 'Refill', 'Refill', 1, 1, '2022-11-15 02:10:34', 1);
-- SEPARATOR --
CREATE TABLE `refill_status` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `refill_apiid` int(11) DEFAULT NULL,
  `order_url` text NOT NULL,
  `creation_date` datetime DEFAULT NULL,
  `ending_date` date DEFAULT NULL,
  `service_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `refill_status` enum('Pending','Refilling','Completed','Rejected','Error') DEFAULT 'Pending',
  `order_apiid` int(11) DEFAULT 0,
  `refill_response` text DEFAULT NULL,
  `refill_where` enum('site','api') DEFAULT 'site'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `crons_report` (
  `crons_id` int(11) NOT NULL,
  `crons_service_name` varchar(255) NOT NULL,
  `crons_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `crons_detail` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `currency` (
  `id` int(11) NOT NULL,
  `symbol` text DEFAULT NULL,
  `value` double DEFAULT NULL,
  `name` varchar(225) NOT NULL,
  `status` enum('1','2') NOT NULL DEFAULT '1',
  `default` enum('2','1') NOT NULL DEFAULT '2',
  `nouse` enum('1','2') NOT NULL DEFAULT '2'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `currency` (`id`, `symbol`, `value`, `name`, `status`, `default`, `nouse`) VALUES
(1, '$', 1, 'USD', '1', '1', '2'),
(2, '₹', 75.4, 'INR', '1', '2', '2'),
(3, '€', 0.89, 'EUR', '1', '2', '2'),
(4, '₽', 79.37, 'Ruble', '1', '2', '2'),
(5, 'Rs', 177.46, 'PKR', '1', '2', '2'),
(6, '¥', 6.36, 'Yuan', '1', '2', '2'),
(9, 'रु', 127, 'NPR', '1', '2', '2'),
(7, 'EGP', 18.95, 'جنية مصري', '1', '2', '2'),
(10, 'Rs', 80, 'RS', '1', '2', '2'),
(11, 'Twd', 30, 'Twd', '1', '2', '2');
-- SEPARATOR --
CREATE TABLE `files` (
  `id` int(11) NOT NULL,
  `link` text DEFAULT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `guard_log` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `action` varchar(225) NOT NULL,
  `date` varchar(225) NOT NULL,
  `ip` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `integrations` (
  `id` int(11) NOT NULL,
  `name` varchar(225) NOT NULL,
  `description` varchar(225) NOT NULL,
  `icon_url` varchar(225) NOT NULL,
  `code` text NOT NULL,
  `visibility` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `integrations` (`id`, `name`, `description`, `icon_url`, `code`, `visibility`, `status`) VALUES
(1, 'Beamer', 'Announce updates and get feedback with in-app notification center, widgets and changelog', '/img/integrations/Beamer.svg', '<!-- GetButton.io widget -->\r\n<script type=\"text/javascript\">\r\n    (function () {\r\n        var options = {\r\n            whatsapp: \"+201008968427\", // WhatsApp number\r\n            call_to_action: \"To buy this product contact me\", // Call to action\r\n            button_color: \"#FF6550\", // Color of button\r\n            position: \"right\", // Position may be \'right\' or \'left\'\r\n            pre_filled_message: \"Hello, I want to buy a perfect panel script\", // WhatsApp pre-filled message\r\n        };\r\n        var proto = document.location.protocol, host = \"getbutton.io\", url = proto + \"//static.\" + host;\r\n        var s = document.createElement(\'script\'); s.type = \'text/javascript\'; s.async = true; s.src = url + \'/widget-send-button/js/init.js\';\r\n        s.onload = function () { WhWidgetSendButton.init(host, proto, options); };\r\n        var x = document.getElementsByTagName(\'script\')[0]; x.parentNode.insertBefore(s, x);\r\n    })();\r\n</script>\r\n<!-- /GetButton.io widget -->', 1, 2),
(2, 'Getsitecontrol', 'It helps you prevent website visitors from leaving your website without taking any action.', '/img/integrations/Getsitecontrol.svg', '<script>\r\n	var beamer_config = {\r\n		product_id : \"mTnKEftt44491\" //DO NOT CHANGE: This is your product code on Beamer\r\n	};\r\n</script>\r\n<script type=\"text/javascript\" src=\"https://app.getbeamer.com/js/beamer-embed.js\" defer=\"defer\"></script>\r\n					', 3, 1),
(3, 'Google Analytics', 'Statistics and basic analytical tools for search engine optimization (SEO) and marketing purposes', '/img/integrations/Google%20Analytics.svg', '', 1, 1),
(4, 'Google Tag manager', 'Manage all your website tags without editing the code using simple tag management solutions', '/img/integrations/Google%20Tag%20manager.svg', '', 1, 2),
(5, 'JivoChat', 'All-in-one business messenger to talk to customers: live chat, phone, email and social', '/img/integrations/JivoChat.svg', '', 1, 1),
(6, 'Onesignal', 'Leader in customer engagement, empowers mobile push, web push, email, in-app messages', '/img/integrations/Onesignal.svg', '', 1, 1),
(7, 'Push alert', 'Increase reach, revenue, retarget users with Push Notifications on desktop and mobile', '/img/integrations/Push%20alert.svg', '<!-- PushAlert -->\r\n<script type=\"text/javascript\">\r\n        (function(d, t) {\r\n                var g = d.createElement(t),\r\n                s = d.getElementsByTagName(t)[0];\r\n                g.src = \"https://cdn.pushalert.co/integrate_eda0a20844eebca311bcfe9e81831780.js\";\r\n                s.parentNode.insertBefore(g, s);\r\n        }(document, \"script\"));\r\n</script>\r\n<!-- End PushAlert -->', 1, 1),
(8, 'Smartsupp', 'Live chat, email inbox and Facebook Messenger in one customer messaging platform', '/img/integrations/Smartsupp.svg', '', 1, 1),
(9, 'Tawk.to', 'Track and chat with visitors on your website, mobile app or a free customizable page', '/img/integrations/Tawk.to.svg', '', 1, 1),
(10, 'Tidio', 'Communicator for businesses that keep live chat, chatbots, Messenger and email in one place', '/img/integrations/Tidio.svg', '', 1, 1),
(11, 'Zendesk Chat', 'Helps respond quickly to customer questions, reduce wait times and increase sales', '/img/integrations/Zendesk%20Chat.svg', '', 1, 1),
(12, 'Getbutton.io', 'Chat with website visitors through popular messaging apps. Whatsapp, messenger etc. contact button.', '/img/integrations/Getbutton.svg', '62999477907', 3, 2),
(13, 'Google reCAPTCHA v2', 'It uses an advanced risk analysis engine and adaptive challenges to prevent malware from engaging in abusive activities on your website.', '/img/integrations/reCAPTCHA.svg', '', 1, 2),
(14, 'SEO Adjustments', 'Search Engine Optimization (SEO) is the name given to all the work done to make websites perform better in search engines.', '/img/integrations/Seo settings.png', '', 1, 2);
-- SEPARATOR --
CREATE TABLE `kuponlar` (
  `id` int(11) NOT NULL,
  `kuponadi` varchar(255) NOT NULL,
  `adet` int(11) NOT NULL,
  `tutar` double NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
-- SEPARATOR --
CREATE TABLE `kupon_kullananlar` (
  `id` int(11) NOT NULL,
  `uye_id` int(11) NOT NULL,
  `kuponadi` varchar(255) NOT NULL,
  `tutar` double NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
-- SEPARATOR --
CREATE TABLE `languages` (
  `id` int(11) NOT NULL,
  `language_name` varchar(225) NOT NULL,
  `language_code` varchar(225) NOT NULL,
  `language_type` enum('2','1') NOT NULL DEFAULT '2',
  `default_language` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `languages` (`id`, `language_name`, `language_code`, `language_type`, `default_language`) VALUES
(1, 'English (US)', 'en', '2', '1'),
(12, 'Arabic (SA)', 'ar', '2', '0'),
(14, '中文（台灣）', 'zh-TW', '2', '0');
-- SEPARATOR --
CREATE TABLE `menu` (
  `id` int(11) NOT NULL,
  `name` varchar(225) CHARACTER SET utf8 NOT NULL,
  `tag` varchar(225) CHARACTER SET utf8 NOT NULL,
  `status` int(11) NOT NULL,
  `public` int(11) NOT NULL,
  `edit` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
-- SEPARATOR --
INSERT INTO `menu` (`id`, `name`, `tag`, `status`, `public`, `edit`) VALUES
(2, 'API', 'api', 2, 2, 0),
(3, 'User Agreement', 'terms', 2, 2, 0),
(4, 'Frequently Asked Questions', 'faq', 2, 2, 0),
(5, 'Blog <span class=\"fa fa-info-circle\" data-toggle=\"tooltip\" data-placement=\"top\"></span>', 'blog', 1, 1, 0);
-- SEPARATOR --
CREATE TABLE `menus` (
  `id` int(11) NOT NULL,
  `name` text COLLATE utf8mb4_bin NOT NULL,
  `menu_line` double NOT NULL,
  `type` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '2',
  `slug` varchar(225) COLLATE utf8mb4_bin NOT NULL DEFAULT '2',
  `icon` varchar(225) COLLATE utf8mb4_bin DEFAULT NULL,
  `menu_status` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '1',
  `visible` enum('Internal','External') COLLATE utf8mb4_bin NOT NULL DEFAULT 'Internal',
  `active` varchar(225) COLLATE utf8mb4_bin NOT NULL,
  `tiptext` varchar(225) COLLATE utf8mb4_bin NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
-- SEPARATOR --
INSERT INTO `menus` (`id`, `name`, `menu_line`, `type`, `slug`, `icon`, `menu_status`, `visible`, `active`, `tiptext`) VALUES
(2, 'New Order', 2, '2', '/', 'fas fa-cart-plus', '1', 'Internal', 'neworder', 'Shown only if Mass Order system enabled for use'),
(4, 'Refill', 5, '2', '/refill', 'fas fa-recycle', '1', 'Internal', 'refill', 'Shown only if user have at least one refill task'),
(5, 'Login', 2, '2', '/', 'fas fa-sign-in-alt', '1', 'External', 'login', ''),
(6, 'Services', 6, '2', '/services', 'fas fa-cogs', '1', 'Internal', 'services', ''),
(7, 'Add Funds', 7, '2', '/addfunds', 'fas fa-cogs', '1', 'Internal', 'addfunds', ''),
(9, 'Tickets ', 9, '2', '/tickets', 'fas fa-headset', '1', 'Internal', 'tickets', ''),
(8, 'Orders', 8, '2', '/orders', 'fas fa-cogs', '1', 'Internal', 'orders', ''),
(11, 'Refer & Earn', 8, '1', '/refer', 'fas fa-cogs', '1', 'Internal', 'refer', 'Shown only if affiliate system enabled for use'),
(15, 'Api', 4, '2', '/api', 'fas fa-code', '1', 'External', 'api', ''),
(18, 'Services', 5, '2', '/services', 'fas fa-list-alt', '1', 'External', 'terms', ''),
(45, 'terms', 13, '2', 'terms', 'fas fa-cogs', '1', 'Internal', 'terms', '');
-- SEPARATOR --
CREATE TABLE `modules` (
  `id` int(11) NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `ajax_name` text NOT NULL,
  `status` int(11) NOT NULL DEFAULT 2,
  `mod_sec` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `modules` (`id`, `name`, `description`, `ajax_name`, `status`, `mod_sec`) VALUES
(1, 'Reference System', 'Existing users invite new users and receive commissions on all their payments. Users can request payment when they reach the minimum payment.', 'module_ref', 2, 1),
(2, 'Child panel', 'A panel with limited features that can only pull APIs from you. Users can order child panels from your panel.', 'module_child', 2, 1),
(3, 'Free Balance', 'One-time free automatic balance for newly registered members.', 'module_balance', 2, 1),
(4, 'Support System', 'The canned answers you enter in the headings you add are automatically sent to customers who create new support requests.', '', 2, 1),
(6, 'Guard', '24/7 Maximum security, limit all activities! 100% protection against attacks.', 'module_guard', 1, 2),
(7, 'Cache ', 'It is aimed to create a more efficient system that increases the site speed by reducing the resource consumption of the site.', 'module_cache', 2, 1);
-- SEPARATOR --
CREATE TABLE `news` (
  `id` int(11) NOT NULL,
  `news_icon` varchar(225) NOT NULL,
  `news_title` varchar(225) NOT NULL,
  `news_content` varchar(225) NOT NULL,
  `news_date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `news` (`id`, `news_icon`, `news_title`, `news_content`, `news_date`) VALUES
(13, 'facebook', 'test', 'test', '2022-07-25 19:52:45');
-- SEPARATOR --
CREATE TABLE `notifications` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
-- SEPARATOR --
CREATE TABLE `orders` (
  `order_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `api_orderid` int(11) NOT NULL DEFAULT 0,
  `order_error` text NOT NULL,
  `order_detail` text NOT NULL,
  `order_api` int(11) NOT NULL DEFAULT 0,
  `api_serviceid` int(11) NOT NULL DEFAULT 0,
  `api_charge` double DEFAULT NULL,
  `api_currencycharge` double NOT NULL DEFAULT 1,
  `order_profit` double NOT NULL,
  `order_quantity` double NOT NULL,
  `order_extras` text NOT NULL,
  `order_charge` double DEFAULT NULL,
  `dripfeed` enum('1','2','3') DEFAULT '1' COMMENT '2 -> ON, 1 -> OFF',
  `dripfeed_id` double NOT NULL DEFAULT 0,
  `subscriptions_id` double NOT NULL DEFAULT 0,
  `subscriptions_type` enum('1','2') NOT NULL DEFAULT '1' COMMENT '2 -> ON, 1 -> OFF',
  `dripfeed_totalcharges` double DEFAULT NULL,
  `dripfeed_runs` double DEFAULT NULL,
  `dripfeed_delivery` double NOT NULL DEFAULT 0,
  `dripfeed_interval` double DEFAULT NULL,
  `dripfeed_totalquantity` double DEFAULT NULL,
  `dripfeed_status` enum('active','completed','canceled') NOT NULL DEFAULT 'active',
  `order_url` text NOT NULL,
  `order_start` double NOT NULL DEFAULT 0,
  `order_finish` double NOT NULL DEFAULT 0,
  `order_remains` double NOT NULL DEFAULT 0,
  `order_create` datetime NOT NULL,
  `order_status` enum('pending','inprogress','completed','partial','processing','canceled') NOT NULL DEFAULT 'pending',
  `subscriptions_status` enum('active','paused','completed','canceled','expired','limit') NOT NULL DEFAULT 'active',
  `subscriptions_username` text DEFAULT NULL,
  `subscriptions_posts` double DEFAULT NULL,
  `subscriptions_delivery` double NOT NULL DEFAULT 0,
  `subscriptions_delay` double DEFAULT NULL,
  `subscriptions_min` double DEFAULT NULL,
  `subscriptions_max` double DEFAULT NULL,
  `subscriptions_expiry` date DEFAULT NULL,
  `last_check` datetime NOT NULL,
  `order_where` enum('site','api') NOT NULL DEFAULT 'site',
  `show_refill` enum('0','1') NOT NULL DEFAULT '1',
  `refill_status` enum('Pending','Refilling','Completed','Rejected','Error') NOT NULL DEFAULT 'Pending',
  `is_refill` enum('1','2') NOT NULL DEFAULT '1',
  `refill` varchar(255) NOT NULL DEFAULT '1',
  `api_refillid` double NOT NULL DEFAULT 0,
   `last_refill_time` datetime NOT NULL,
    `last_cancel_time` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `pages` (
  `page_id` int(11) NOT NULL,
  `page_name` varchar(225) NOT NULL,
  `page_get` varchar(225) NOT NULL,
  `page_content` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `pages` (`page_id`, `page_name`, `page_get`, `page_content`) VALUES
(1, 'Login', 'auth', ''),
(2, 'Services', 'services', ''),
(3, 'Frequently Asked Questions', 'faq', ''),
(4, 'Contracts', 'terms', ''),
(5, 'New order', 'neworder', '<p>htggggggggggggggggggggggggggggggggggggggggggggggggggg</p>'),
(6, 'Add Balance', 'addfunds', ''),
(7, 'Child panels', 'child-panels', ''),
(8, 'Support', 'tickets', '<p>gggggggggggggggggg</p>'),
(9, 'Invite Earn', 'affiliates', '');
-- SEPARATOR --
CREATE TABLE `payments` (
  `payment_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `client_balance` double NOT NULL DEFAULT 0,
  `payment_amount` double NOT NULL,
  `papara_amount` double DEFAULT NULL,
  `payment_privatecode` double DEFAULT NULL,
  `payment_method` int(11) NOT NULL,
  `payment_status` enum('1','2','3') NOT NULL DEFAULT '1',
  `payment_delivery` enum('1','2') NOT NULL DEFAULT '1',
  `payment_note` text DEFAULT NULL,
  `payment_mode` enum('Manuel','Otomatik') NOT NULL DEFAULT 'Otomatik',
  `payment_create_date` datetime NOT NULL,
  `payment_update_date` datetime NOT NULL,
  `payment_ip` varchar(225) NOT NULL,
  `payment_extra` text NOT NULL,
  `payment_bank` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `payments_bonus` (
  `bonus_id` int(11) NOT NULL,
  `bonus_method` int(11) NOT NULL,
  `bonus_from` double NOT NULL,
  `bonus_amount` double NOT NULL,
  `bonus_type` enum('1','2') NOT NULL DEFAULT '2'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `payment_methods` (
  `id` int(11) NOT NULL,
  `method_name` varchar(225) NOT NULL,
  `method_get` varchar(225) NOT NULL,
  `method_min` double NOT NULL,
  `method_max` double NOT NULL,
  `method_type` enum('1','2') NOT NULL DEFAULT '2' COMMENT '2 -> ON, 1 -> OFF	',
  `method_extras` text NOT NULL,
  `method_line` double NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `payment_methods` (`id`, `method_name`, `method_get`, `method_min`, `method_max`, `method_type`, `method_extras`, `method_line`) VALUES
(1, 'Paytr', 'paytr', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Paytr\",\"min\":\"1\",\"max\":\"0\",\"merchant_id\":\"\",\"merchant_key\":\"\",\"merchant_salt\":\"\",\"fee\":\"0\"}', 11),
(2, 'Paytrhavale', 'paytr_havale', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Paytrhavale\",\"min\":\"1\",\"max\":\"0\",\"merchant_id\":\"\",\"merchant_key\":\"\",\"merchant_salt\":\"\",\"fee\":\"0\"}', 12),
(3, 'Paywant', 'paywant', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Paywant\",\"min\":\"1\",\"max\":\"0\",\"apiKey\":\"\",\"apiSecret\":\"\",\"fee\":\"0\",\"commissionType\":\"2\",\"payment_type\":[\"1\",\"2\",\"3\"]}', 13),
(4, 'Shopier', 'shopier', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Shopier\",\"min\":\"1\",\"max\":\"0\",\"apiKey\":\"bae6993a1afa477d8329ffb0c2ca9385\",\"apiSecret\":\"76aca9729205bd2231bf0098476c3e23\",\"website_index\":\"1\",\"processing_fee\":\"1\",\"fee\":\"0\"}', 14),
(5, 'Shoplemo', 'shoplemo', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Shoplemo\",\"min\":\"1\",\"max\":\"0\",\"apiKey\":\"\",\"apiSecret\":\"\",\"fee\":\"0\"}', 15),
(6, 'CoinPayments', 'coinpayments', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Coinpayments\",\"min\":\"1\",\"max\":\"0\",\"coinpayments_public_key\":\"b4d250001441c32daee41e40179e6804d9870c87ecdcfbba3d66bd2a419b993b\",\"coinpayments_private_key\":\"81828a4Ac33d289C6E645Fb97Af44ebB47b3e06876edE5922653a1C9eBB5071b\",\"coinpayments_currency\":\"BTC\",\"merchant_id\":\"3a735b6cc9c06a0cc0f62de3da3cfc1b\",\"ipn_secret\":\"a56864A1A94f093d5043aE0ac9E98ac371473390fd8eee639Ab382Ecf5bf4290\",\"fee\":\"5\"}', 5),
(7, 'Banka Ödemeleri', 'havale-eft', 0, 0, '2', '{\"method_type\":\"2\",\"name\":\"Bank manwal\"}', 19),
(9, '2checkout', '2checkout', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"2checkout\",\"min\":\"1\",\"max\":\"0\",\"seller_id\":\"\",\"private_key\":\"\",\"currency\":\"\",\"fee\":\"\"}', 17),
(10, 'CardLink', 'cardlink', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Card link\",\"min\":\"1\",\"max\":\"0\",\"shop_id\":\"oa2QqqX2Al\",\"private_key\":\"17538|P8t5gcN4OJENEQVlC89MfVFGNLWbdntBKUPv3Ll2\",\"currency\":\"$\",\"fee\":\"6\"}', 20),
(11, 'Paypal', 'paypal', 10, 100, '2', '{\"method_type\":\"2\",\"mode\":\"live\",\"name\":\"paypal\",\"min\":\"10\",\"max\":\"100\",\"clientId\":\"AdUQ-ThZ3eYPwnsTfh_qWc0w8k9QJRm6U50q75NfISEev3N882HfLSwLdjcdQmBVRuTuOk4Ryf5U3eW9\",\"clientSecret\":\"EBVUI0yW3GhPMn0YWZH94bPcjdkbKuQsNETTNnvLTPxKWY2vtxKGOhCN84Xxo7F5m8BMilDrXQqBh3S1\",\"currency\":\"$\",\"fee\":\"10\"}', 6),
(12, 'PayTM', 'paytm', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Paytm\",\"min\":\"1\",\"max\":\"0\",\"merchant_key\":\"m0qUqDR9g8W1e!!w\",\"merchant_mid\":\"JrZTAt95266294327105\",\"merchant_website\":\"DEFAULT\",\"currency\":\"INR\",\"fee\":\"1\"}', 18),
(13, 'Weepay', 'weepay', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Weepay\",\"min\":\"1\",\"max\":\"0\",\"bayi_id\":\"\",\"api_key\":\"\",\"secret_key\":\"\",\"currency\":\"USD\",\"fee\":\"0\"}', 16),
(16, 'LemonSqueezy', 'lemon', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Credit Card & Paypal\",\"min\":\"1\",\"max\":\"0\",\"merchant_id\":\"\",\"merchant_key\":\"\",\"merchant_salt\":\"\",\"fee\":\"0\"}', 8),
(17, '<b>FundsSystem</b>', 'funds', 1, 0, '2', '{}', 28),
(18, 'Perfect Money', 'perfectmoney', 1, 10000, '2', '{\"method_type\":\"2\",\"name\":\"Perfect Money\",\"min\":\"1\",\"max\":\"10000\",\"passphrase\":\"C870tt8LMu5lGCSaAtGbupCyg\",\"usd\":\"U33977610\",\"merchant_website\":\"wixout\",\"fee\":\"1\"}', 2),
(19, 'Payeer', 'payeer', 5, 0, '2', '{\"method_type\":\"2\",\"name\":\"Payeer\",\"min\":\"5\",\"max\":\"0\",\"account\":\"P1070554281\",\"client_secret\":\"M5T0KdVS8vX8ZFxR\",\"user_id\":\"1651807285\",\"user_pass\":\"M5T0KdVS8vX8ZFxR\",\"m_shop\":\"1714901357\"}', 1),
(20, 'Opay', 'opay', 10, 1000, '2', '{\"method_type\":\"2\",\"is_demo\":\"0\",\"name\":\"opay.eg\",\"min\":\"10\",\"max\":\"1000\",\"merchant_id\":\"281822042386512\",\"secret_key\":\"OPAYPRV16506671920350.2433123985802288\",\"public_key\":\"OPAYPUB16506671920350.8432950392339029\",\"dollar_rate\":\"19.5\"}', 9),
(21, 'Bkash', 'custom', 0, 0, '2', '{\"method_type\":\"2\",\"name\":\"Bkash\",\"content\":\"<h4 style=\\\"font-family: Poppins, sans-serif; color: rgb(209, 197, 222); text-align: center;\\\"><b><font color=\\\"#ff0000\\\" style=\\\"background-color: rgb(255, 255, 0);\\\">Follow the Steps\\u00a0<br><\\/font><\\/b><\\/h4><h5 style=\\\"font-family: Poppins, sans-serif; color: rgb(209, 197, 222); text-align: center;\\\"><b><font color=\\\"#ff0000\\\" style=\\\"background-color: rgb(255, 255, 0);\\\">You must follow the steps\\/info below, or else your fund will not be added.<\\/font><\\/b><\\/h5><p style=\\\"text-align: center;\\\"><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\">Send a\\u00a0<\\/span><\\/font><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">minimum of 50$<\\/b><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\">\\u00a0or more ( If you send less, we will not add funds)<\\/span><\\/font><br><br><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">--> USDT<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">\\u00a0<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">(<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">\\u00a0TRC20\\u00a0<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">)<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">\\u00a0<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">:\\u00a0<\\/b><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\"><b>TGqMoz4xKTq2cTZKZ3URo4Uh9VTkWyJg7c<\\/b><\\/span><\\/font><br><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">--> BUSD (\\u00a0<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">BEP20<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">\\u00a0) :\\u00a0<\\/b><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\"><b>0xe379a03651c70572f0ad38e6a3c76416edb677fa<\\/b><\\/span><\\/font><br><br><\\/p><p style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; text-align: center;\\\">After Sending Payment create a ticket with the below Info<br>1.\\u00a0<b>Coin name<\\/b>\\u00a0: ( Trc20 or Erc20 Or BUSD )<br>2.\\u00a0<b>Amount<\\/b>: XXX<br>3.\\u00a0<b>Confirmation URL<\\/b>: Payment Confirmation URL ( We need this URL to add funds)<\\/p><p style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; text-align: center;\\\"><b>Bonus<\\/b>: 50$ to 99$ ~\\u00a0<b>2%<\\/b>, 100$ - 499$ ~\\u00a0<b>3%<\\/b>\\u00a0, 500$ - 999$ ~\\u00a0<b>4%<\\/b>, 1000$ - 2499$\\u00a0<b>5%<\\/b>, 2500$+\\u00a0<b>6%<\\/b><\\/p>\"}', 10),
(22, 'Webmoney', 'webmoney', 1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Webmoney\",\"min\":\"1\",\"max\":\"0\",\"wmid\":\"434857272126\",\"purse\":\"Z426824862368\",\"secret_key\":\"E5076CDB-DEC7-4A8F-9A07-97FD15054367\",\"fee\":\"0\"}', 3),
(23, 'Kashier', 'kashier', 1, 1000, '2', '{\"method_type\":\"2\",\"is_demo\":\"0\",\"name\":\"Kashier EG\",\"min\":\"1\",\"max\":\"1000\",\"merchant_id\":\"MID-8448-188\",\"secret_key\":\"37b07c0e51757aeeebd7c62c5af3a2a4$ab069a3ab2fe45241d3ce117c2ef6e7a44ba3d656ab1f350abb562ee249724cd35373f62419dcda3baf6892383cb4a3c\",\"api_key\":\"ab5fda52-ca9f-4a34-bdac-8a17bb33dd04\",\"dollar_rate\":\"19\"}', 7),
(24, 'Coinbase', 'coinbase', 0.1, 0, '2', '{\"method_type\":\"2\",\"name\":\"Coinbase ( Cryptocurrency )\",\"min\":\"0.1\",\"max\":\"0\",\"api_key\":\"32f4877f-39e4-451f-a26e-13c1d14878ac\",\"webhook_api\":\"\",\"fee\":\"3\"}', 4),
(25, 'Wish Money', 'wish_money', 1, 0, '2', '{\"method_type\":\"2\",\"mode\":\"live\",\"name\":\"mastercard- visa- creditcard\",\"min\":\"1\",\"max\":\"0\",\"channel\":\"100000\",\"secret\":\"51a16ba37ba64588dd814bf20c7aaa\",\"website\":\"smmlan.com\",\"fee\":\"3\"}', 21),
(26, 'Stripe', 'stripe', 1, 100, '2', '{\"method_type\":\"2\",\"name\":\"Stripe\",\"min\":\"1\",\"max\":\"100\",\"stripe_publishable_key\":\"pk_live_51JMykFSH4sLcQTY6GoEZCk6lBZiFLFFfE2HHoHibxAoUBlKpdKJnPM5HUI9eEX4v8reRpKtCoQlwWowS5ALsI22u00vd4GGZQ0\",\"stripe_secret_key\":\"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\",\"stripe_webhooks_secret\":\"we_1LJ2rYBGk2tB5CmIOX7uaako\",\"fee\":\"1\",\"currency\":\"USD\"}', 23),
(27, 'Thawani', 'thawani', 1, 0, '2', '{\"method_type\":\"2\",\"is_demo\":\"1\",\"name\":\"Thawani\",\"min\":\"1\",\"max\":\"0\",\"secret_key\":\"rRQ26GcsZzoEhbrP2HZvLYDbn9C9et\",\"publishable_key\":\"HGvTMLDssJghr9tlN9gr4DVYt0qyBy\",\"dollar_rate\":\"0.39\",\"fee\":\"2\"}', 24),
(28, 'Youcan', 'youcan', 1, 0, '2', '{\"method_type\":\"2\",\"is_demo\":\"0\",\"name\":\"Youcan\",\"min\":\"1\",\"max\":\"0\",\"private_key\":\"\",\"public_key\":\"\",\"fee\":\"1\"}', 25),
(29, 'Esewa', 'esewa', 0.01, 0, '2', '{\"method_type\":\"2\",\"is_demo\":\"0\",\"name\":\"Wallet\",\"min\":\"0.01\",\"max\":\"0\",\"merchant_id\":\"NP-ES-ARART\",\"fee\":\"3\",\"dollar_rate\":\"127\"}', 22),
(30, 'Khalti', 'khalti', 0.01, 0, '2', '{\"method_type\":\"2\",\"name\":\"Ewallet\",\"min\":\"0.01\",\"max\":\"0\",\"public_key\":\"live_public_key_45c04ed397a341bbb325c248aca0f40c\",\"secret_key\":\"live_secret_key_7fad781d6f534587a5f739ab711f0b78\",\"fee\":\"3\",\"dollar_rate\":\"127\"}', 26),
(31, 'Newebpay', 'newebpay', 0.01, 0, '2', '{\"method_type\":\"2\",\"name\":\"Newebpay\",\"min\":\"0.01\",\"max\":\"0\",\"merchant_id\":\"MS1627077916\",\"hash_key\":\"JIZOc2nqweLgczGMORXvt55wKBCOWrJ5\",\"hash_iv\": \"PqAMtuk6BpYbmQpC\",\"fee\":\"3\",\"dollar_rate\":\"30\"}', 27),
(32, 'Airtm', 'airtm', 0.01, 0, '2', '{\"method_type\":\"2\",\"is_demo\":\"1\",\"name\":\"Airtm\",\"min\":\"0.01\",\"max\":\"0\",\"app_key\":\"MS1627077916\",\"secret_key\":\"JIZOc2nqweLgczGMORXvt55wKBCOWrJ5\",\"dollar_rate\":\"30\"}', 32),
(33, 'Mollie', 'mollie', 0.01, 0, '2', '{\"method_type\":\"2\",\"name\":\"Mollie\",\"min\":\"0.01\",\"max\":\"0\",\"api_key\":\"test_f3w3ktzeyA7Eh5GkzV4k9mMCGxVNpp\",\"fee\":\"3\",\"is_demo\":\"1\",\"dollar_rate\":\"30\"}', 33),
(34, 'Payoneer', 'payoneer', 0, 0, '2', '{\"method_type\":\"2\",\"name\":\"Payoneer\",\"content\":\"<h4 style=\\\"font-family: Poppins, sans-serif; color: rgb(209, 197, 222); text-align: center;\\\"><b><font color=\\\"#ff0000\\\" style=\\\"background-color: rgb(255, 255, 0);\\\">Follow the Steps\\u00a0<br><\\/font><\\/b><\\/h4><h5 style=\\\"font-family: Poppins, sans-serif; color: rgb(209, 197, 222); text-align: center;\\\"><b><font color=\\\"#ff0000\\\" style=\\\"background-color: rgb(255, 255, 0);\\\">You must follow the steps\\/info below, or else your fund will not be added.<\\/font><\\/b><\\/h5><p style=\\\"text-align: center;\\\"><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\">Send a\\u00a0<\\/span><\\/font><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">minimum of 50$<\\/b><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\">\\u00a0or more ( If you send less, we will not add funds)<\\/span><\\/font><br><br><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">--> USDT<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">\\u00a0<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">(<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">\\u00a0TRC20\\u00a0<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">)<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">\\u00a0<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">:\\u00a0<\\/b><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\"><b>TGqMoz4xKTq2cTZKZ3URo4Uh9VTkWyJg7c<\\/b><\\/span><\\/font><br><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">--> BUSD (\\u00a0<\\/b><span style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; font-weight: 400;\\\">BEP20<\\/span><b style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px;\\\">\\u00a0) :\\u00a0<\\/b><font color=\\\"#d1c5de\\\" face=\\\"Poppins, sans-serif\\\"><span style=\\\"font-size: 15px;\\\"><b>0xe379a03651c70572f0ad38e6a3c76416edb677fa<\\/b><\\/span><\\/font><br><br><\\/p><p style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; text-align: center;\\\">After Sending Payment create a ticket with the below Info<br>1.\\u00a0<b>Coin name<\\/b>\\u00a0: ( Trc20 or Erc20 Or BUSD )<br>2.\\u00a0<b>Amount<\\/b>: XXX<br>3.\\u00a0<b>Confirmation URL<\\/b>: Payment Confirmation URL ( We need this URL to add funds)<\\/p><p style=\\\"color: rgb(209, 197, 222); font-family: Poppins, sans-serif; font-size: 15px; text-align: center;\\\"><b>Bonus<\\/b>: 50$ to 99$ ~\\u00a0<b>2%<\\/b>, 100$ - 499$ ~\\u00a0<b>3%<\\/b>\\u00a0, 500$ - 999$ ~\\u00a0<b>4%<\\/b>, 1000$ - 2499$\\u00a0<b>5%<\\/b>, 2500$+\\u00a0<b>6%<\\/b><\\/p>\"}', 10),
(35, 'Mercadopago', 'mercadopago', 0, 0, '2', '{\"method_type\":\"2\",\"name\":\"Mercadopago\",\"min\":\"0.01\",\"max\":\"0\",\"access_token\":\"APP_USR-2737129607544270-102515-8edbd2fa219c00396f0937e21470e767-252056445\",\"fee\":\"3\",\"is_demo\":\"1\",\"dollar_rate\":\"5.31\"}', 35);
-- SEPARATOR --
CREATE TABLE `proxy` (
  `id` int(11) NOT NULL,
  `user` varchar(225) CHARACTER SET utf8 NOT NULL,
  `pass` varchar(225) CHARACTER SET utf8 NOT NULL,
  `ip` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `port` varchar(225) CHARACTER SET utf8 DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
-- SEPARATOR --
CREATE TABLE `referral` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `refferal` int(11) NOT NULL,
  `action` text CHARACTER SET utf8 NOT NULL,
  `register_date` varchar(225) CHARACTER SET utf8 NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
-- SEPARATOR --
CREATE TABLE `reset_log` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `token` varchar(225) NOT NULL,
  `type` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
-- SEPARATOR --
CREATE TABLE `serviceapi_alert` (
  `id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `serviceapi_alert` text NOT NULL,
  `servicealert_extra` text NOT NULL,
  `servicealert_date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `services` (
  `service_id` int(11) NOT NULL,
  `service_api` int(11) NOT NULL DEFAULT 0,
  `api_service` int(11) NOT NULL DEFAULT 0,
  `api_servicetype` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '2',
  `api_detail` text CHARACTER SET utf8 NOT NULL,
  `category_id` int(11) NOT NULL,
  `service_line` double NOT NULL,
  `service_type` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '2',
  `service_package` enum('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17') CHARACTER SET utf8 NOT NULL,
  `service_name` text NOT NULL,
  `service_description` text NOT NULL,
  `service_price` double NOT NULL DEFAULT 0,
  `sync_price` int(11) NOT NULL,
  `sync_rate` int(11) NOT NULL,
  `service_min` double NOT NULL,
  `sync_min` int(11) NOT NULL,
  `service_max` double NOT NULL,
  `sync_max` int(11) NOT NULL,
  `service_dripfeed` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '1',
  `service_autotime` double NOT NULL DEFAULT 0,
  `service_autopost` double NOT NULL DEFAULT 0,
  `service_speed` enum('1','2','3','4') CHARACTER SET utf8 NOT NULL,
  `want_username` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '1',
  `service_secret` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '2',
  `price_type` enum('normal','percent','amount') CHARACTER SET utf8 NOT NULL DEFAULT 'normal',
  `price_cal` text CHARACTER SET utf8 NOT NULL,
  `start_count` enum('none','instagram_follower','instagram_photo','') CHARACTER SET utf8 NOT NULL,
  `instagram_private` enum('1','2') CHARACTER SET utf8 NOT NULL,
  `name_lang` text NOT NULL,
  `description_lang` text CHARACTER SET utf8 NOT NULL,
  `cancel_type` int(11) NOT NULL DEFAULT 1,
  `refill_type` int(11) NOT NULL DEFAULT 1,
  `refill_days` int(11) NOT NULL DEFAULT 30,
  `refill_hours` int(11) NOT NULL DEFAULT 24,
  `sync_lastcheck` varchar(225) DEFAULT NULL,
  `provider_lastcheck` varchar(225) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;
-- SEPARATOR --
CREATE TABLE `service_api` (
  `id` int(11) NOT NULL,
  `api_name` varchar(225) NOT NULL,
  `api_url` text NOT NULL,
  `api_key` varchar(225) NOT NULL,
  `api_type` int(11) NOT NULL,
  `api_limit` double NOT NULL DEFAULT 0,
  `api_alert` enum('1','2') NOT NULL DEFAULT '2' COMMENT '2 -> Gönder, 1 -> Gönderildi'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `service_api` (`id`, `api_name`, `api_url`, `api_key`, `api_type`, `api_limit`, `api_alert`) VALUES
(41, 'smmz.net', 'https://smmz.net/api/v2', 'd962cf1178673350e9e8ead8c6883aac', 1, 0, '2');
-- SEPARATOR --
CREATE TABLE `settings` (
  `id` int(11) NOT NULL,
  `site_logo` text DEFAULT NULL,
  `site_name` text DEFAULT NULL,
  `site_title` text NOT NULL,
  `site_description` text NOT NULL,
  `site_keywords` text NOT NULL,
  `site_currency` text NOT NULL,
  `favicon` text DEFAULT NULL,
  `site_language` varchar(225) NOT NULL DEFAULT 'tr',
  `site_theme` text NOT NULL,
  `site_timezone` int(11) NOT NULL,
  `max_ticket` int(11) NOT NULL DEFAULT 2,
  `skype_area` enum('1','2') NOT NULL DEFAULT '1',
  `name_secret` enum('1','2') NOT NULL DEFAULT '1',
  `recaptcha` enum('1','2') NOT NULL DEFAULT '1',
  `recaptcha_key` text DEFAULT NULL,
  `recaptcha_secret` text DEFAULT NULL,
  `custom_header` text DEFAULT NULL,
  `custom_footer` text DEFAULT NULL,
  `ticket_system` enum('1','2') NOT NULL DEFAULT '2',
  `register_page` enum('1','2') NOT NULL DEFAULT '2',
  `terms_checkbox` int(11) NOT NULL DEFAULT 1,
  `service_speed` enum('1','2') NOT NULL DEFAULT '2',
  `service_list` enum('1','2') NOT NULL DEFAULT '2',
  `dolar_charge` double NOT NULL,
  `euro_charge` double NOT NULL,
  `smtp_user` text NOT NULL,
  `smtp_pass` text NOT NULL,
  `smtp_server` text NOT NULL,
  `smtp_port` varchar(225) NOT NULL,
  `smtp_protocol` enum('0','ssl','tls') NOT NULL,
  `alert_type` enum('1','2','3') NOT NULL,
  `alert_newmanuelservice` enum('1','2') NOT NULL,
  `alert_newticket` enum('1','2') NOT NULL,
  `alert_apibalance` enum('1','2') NOT NULL,
  `alert_newpayment` enum('1','2') NOT NULL,
  `alert_newbankpayment` enum('1','2') NOT NULL DEFAULT '1',
  `alert_serviceapialert` enum('1','2') NOT NULL,
  `alert_failorder` enum('1','2') NOT NULL,
  `admin_mail` varchar(225) NOT NULL,
  `resetpass_page` enum('1','2') NOT NULL,
  `resetpass_email` enum('1','2') NOT NULL,
  `site_maintenance` enum('1','2') NOT NULL DEFAULT '2',
  `site_frozen` int(11) NOT NULL DEFAULT 1,
  `sms_provider` varchar(225) NOT NULL,
  `sms_title` varchar(225) NOT NULL,
  `sms_user` varchar(225) NOT NULL,
  `sms_pass` varchar(225) NOT NULL,
  `admin_telephone` varchar(225) NOT NULL,
  `resetpass_sms` enum('1','2') NOT NULL,
  `panel_selling` int(11) NOT NULL,
  `panel_price` int(11) NOT NULL,
  `free_balance` int(11) NOT NULL,
  `free_amount` int(11) NOT NULL,
  `referral` enum('1','2') NOT NULL DEFAULT '1',
  `ref_bonus` int(11) NOT NULL,
  `ref_max` int(11) NOT NULL,
  `ref_type` enum('0','1') NOT NULL DEFAULT '0',
  `cache` int(11) NOT NULL,
  `cache_time` int(11) NOT NULL,
  `guard_system_status` int(11) NOT NULL,
  `guard_services_status` int(11) NOT NULL,
  `guard_services_type` int(11) NOT NULL,
  `guard_notify_status` int(11) NOT NULL,
  `guard_notify_type` int(11) NOT NULL,
  `guard_roles_status` int(11) NOT NULL,
  `guard_roles_type` int(11) NOT NULL,
  `guard_apikey_type` int(11) NOT NULL,
  `neworder_terms` int(11) NOT NULL,
  `guard_cron_system` int(11) NOT NULL DEFAULT 1,
  `secret_key` varchar(225) NOT NULL,
  `avarage` int(11) NOT NULL,
  `sms_verify` int(11) NOT NULL DEFAULT 1,
  `mail_verify` int(11) NOT NULL DEFAULT 1,
  `ser_sync` int(11) NOT NULL,
  `auto_refill` varchar(225) DEFAULT NULL,
  `fundstransfer_fees` varchar(10) NOT NULL,
  `panner_confirmation` enum('1','2') NOT NULL DEFAULT '1' COMMENT '1 -> ON, 2 -> NO',
  `banner_text_ar` text DEFAULT NULL,
  `banner_text_en` text DEFAULT NULL,
  `banner_url` text DEFAULT NULL,
  `notifacon_popup` enum('1','2') NOT NULL DEFAULT '1',
  `notifications_message` varchar(225) NOT NULL,
  `notifications_url` varchar(225) NOT NULL,
  `notifications_url_text` varchar(225) NOT NULL,
  `enable_transfer_funds` int(11) NOT NULL DEFAULT 1,
  `music_url` text DEFAULT NULL,
  `demo_mode` int(11) NOT NULL DEFAULT 0,
    `admin_path` text DEFAULT NULL,
    `whatssapp_numbeeer`  varchar(225) DEFAULT NULL,
    `telgram_channel`  varchar(225) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `settings` (`id`, `site_logo`, `site_name`, `site_title`, `site_description`, `site_keywords`, `site_currency`, `favicon`, `site_language`, `site_theme`, `site_timezone`, `max_ticket`, `skype_area`, `name_secret`, `recaptcha`, `recaptcha_key`, `recaptcha_secret`, `custom_header`, `custom_footer`, `ticket_system`, `register_page`, `terms_checkbox`, `service_speed`, `service_list`, `dolar_charge`, `euro_charge`, `smtp_user`, `smtp_pass`, `smtp_server`, `smtp_port`, `smtp_protocol`, `alert_type`, `alert_newmanuelservice`, `alert_newticket`, `alert_apibalance`, `alert_newpayment`, `alert_newbankpayment`, `alert_serviceapialert`, `alert_failorder`, `admin_mail`, `resetpass_page`, `resetpass_email`, `site_maintenance`, `site_frozen`, `sms_provider`, `sms_title`, `sms_user`, `sms_pass`, `admin_telephone`, `resetpass_sms`, `panel_selling`, `panel_price`, `free_balance`, `free_amount`, `referral`, `ref_bonus`, `ref_max`, `ref_type`, `cache`, `cache_time`, `guard_system_status`, `guard_services_status`, `guard_services_type`, `guard_notify_status`, `guard_notify_type`, `guard_roles_status`, `guard_roles_type`, `guard_apikey_type`, `neworder_terms`, `guard_cron_system`, `secret_key`, `avarage`, `sms_verify`, `mail_verify`, `ser_sync`, `auto_refill`, `fundstransfer_fees`, `panner_confirmation`, `banner_text_ar`, `banner_text_en`, `banner_url`, `notifacon_popup`, `notifications_message`, `notifications_url`, `notifications_url_text`, `enable_transfer_funds`, `music_url`, `demo_mode`,`admin_path`) VALUES
(1, 'images/ff4d5fbbafdf976cfdc032e3bde78de5.png', 'smmcode.net', 'best Perfect Panel Script', 'SMM Panel Script,best Perfect Panel Script', 'SMM Panel Script,best Perfect Panel Script', '1', '', 'ar', 'united', 39600, 1, '1', '2', '1', '6Le866QcAAAAAO5BquPPc0YLLTiJ7CNaEDX2cL5y', '6Le866QcAAAAAEpSeHwn41-ayfWwmAAvtJD1YuqZ', '', '', '2', '2', 2, '1', '2', 1, 1, 'no-reply@wixout.com', 'E*_#*-8H*&Z.qeB', 'smtp.hostinger.com', '587', 'tls', '2', '2', '2', '2', '2', '2', '2', '2', 'pro.20.eg@gmail.com', '2', '2', '2', 1, 'netgsm', '', '', '', '', '1', 2, 10, 2, 0, '2', 10, 100, '0', 2, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, '', 2, 1, 1, 2, '2', '3', '2', ' smm panel script v 3.3', ' smm panel script v 3.6', 'https://www.smmcode.net', '1', 'Buy the latest version now', 'https://www.smmcode.net', 'Pay Now', 1, '', 13,'admin');
-- SEPARATOR --
CREATE TABLE `tasks` (
  `task_id` int(11) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `service_id` int(11) DEFAULT NULL,
  `task_type` varchar(225) DEFAULT NULL,
  `task_status` varchar(225) DEFAULT 'pending',
  `task_date` datetime DEFAULT NULL,
  `refill_orderid` varchar(225) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `themes` (
  `id` int(11) NOT NULL,
  `theme_name` text NOT NULL,
  `theme_dirname` text NOT NULL,
  `theme_extras` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
INSERT INTO `themes` (`id`, `theme_name`, `theme_dirname`, `theme_extras`) VALUES
(5, 'united', 'united', '{\"stylesheets\":[\"css/panel/united/bootstrap.css\",\"css/panel/united/style.css\",\"js\\/datepicker\\/css\\/bootstrap-datepicker3.min.css\",\"https:\\/\\/cdn.mypanel.link\\/css\\/font-awesome\\/css\\/all.min.css\"],\"scripts\":[\"https:\\/\\/cdnjs.cloudflare.com\\/ajax\\/libs\\/jquery\\/1.12.4\\/jquery.min.js\",\"js/panel/united/script.js\",\"js/main.js\",\"js/panel/united/bootstrap.js\",\"js\\/datepicker\\/js\\/bootstrap-datepicker.min.js\",\"js\\/datepicker\\/locales\\/bootstrap-datepicker.tr.min.js\"]}');
-- SEPARATOR --
CREATE TABLE `tickets` (
  `ticket_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `subject` varchar(225) NOT NULL,
  `time` datetime NOT NULL,
  `lastupdate_time` datetime NOT NULL,
  `client_new` enum('1','2') NOT NULL DEFAULT '2',
  `status` enum('pending','answered','closed') NOT NULL DEFAULT 'pending',
  `support_new` enum('1','2') NOT NULL DEFAULT '1',
  `canmessage` enum('1','2') NOT NULL DEFAULT '2'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `ticket_reply` (
  `id` int(11) NOT NULL,
  `ticket_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `support_team` varchar(225) NOT NULL,
  `time` datetime NOT NULL,
  `support` enum('1','2') NOT NULL DEFAULT '1',
  `message` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
CREATE TABLE `ticket_subjects` (
  `subject_id` int(11) NOT NULL,
  `subject` varchar(225) NOT NULL,
  `content` text DEFAULT NULL,
  `auto_reply` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
-- SEPARATOR --
INSERT INTO `ticket_subjects` (`subject_id`, `subject`, `content`, `auto_reply`) VALUES
(11, 'order', 'test', '1');
-- SEPARATOR --
CREATE TABLE `verify_log` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `token` varchar(225) NOT NULL,
  `type` int(11) NOT NULL,
  `verify` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SEPARATOR --
ALTER TABLE `bank_accounts`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `blogs`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `categories`
  ADD PRIMARY KEY (`category_id`);
-- SEPARATOR --
ALTER TABLE `child_panels`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `clients`
  ADD PRIMARY KEY (`client_id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD UNIQUE KEY `username` (`username`);
-- SEPARATOR --
ALTER TABLE `clients_category`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `clients_price`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `clients_service`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `client_report`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `crons`
  ADD PRIMARY KEY (`cron_id`);
-- SEPARATOR --
ALTER TABLE `crons_report`
  ADD PRIMARY KEY (`crons_id`);
-- SEPARATOR --
ALTER TABLE `currency`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `files`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `guard_log`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `integrations`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `kuponlar`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `kupon_kullananlar`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `languages`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `menu`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `menus`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `modules`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `news`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `notifications`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `orders`
  ADD PRIMARY KEY (`order_id`),
  ADD KEY `client_id` (`client_id`),
  ADD KEY `service_id` (`service_id`),
  ADD KEY `api_orderid` (`api_orderid`),
  ADD KEY `order_api` (`order_api`),
  ADD KEY `api_serviceid` (`api_serviceid`);
-- SEPARATOR --
ALTER TABLE `pages`
  ADD PRIMARY KEY (`page_id`),
  ADD UNIQUE KEY `page_id` (`page_id`);
-- SEPARATOR --
ALTER TABLE `payments`
  ADD PRIMARY KEY (`payment_id`),
  ADD UNIQUE KEY `payment_privatecode` (`payment_privatecode`),
  ADD KEY `client_id` (`client_id`),
  ADD KEY `client_balance` (`client_balance`),
  ADD KEY `payment_amount` (`payment_amount`),
  ADD KEY `payment_method` (`payment_method`),
  ADD KEY `payment_status` (`payment_status`);
-- SEPARATOR --
ALTER TABLE `payments_bonus`
  ADD PRIMARY KEY (`bonus_id`);
-- SEPARATOR --
ALTER TABLE `payment_methods`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `proxy`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `referral`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `reset_log`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `token` (`token`);
-- SEPARATOR --
ALTER TABLE `serviceapi_alert`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `services`
  ADD PRIMARY KEY (`service_id`);
-- SEPARATOR --
ALTER TABLE `service_api`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `tasks`
  ADD PRIMARY KEY (`task_id`);
-- SEPARATOR --
ALTER TABLE `themes`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `tickets`
  ADD PRIMARY KEY (`ticket_id`);
-- SEPARATOR --
ALTER TABLE `ticket_reply`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `ticket_subjects`
  ADD PRIMARY KEY (`subject_id`);
-- SEPARATOR --
ALTER TABLE `verify_log`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `bank_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `blogs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
-- SEPARATOR --
ALTER TABLE `categories`
  MODIFY `category_id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `child_panels`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;
-- SEPARATOR --
ALTER TABLE `clients`
  MODIFY `client_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
-- SEPARATOR --
ALTER TABLE `clients_category`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `clients_price`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
-- SEPARATOR --
ALTER TABLE `clients_service`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `client_report`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `crons`
  MODIFY `cron_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
-- SEPARATOR --
ALTER TABLE `crons_report`
  MODIFY `crons_id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `currency`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;
-- SEPARATOR --
ALTER TABLE `files`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
-- SEPARATOR --
ALTER TABLE `guard_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `integrations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;
-- SEPARATOR --
ALTER TABLE `kuponlar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `kupon_kullananlar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `languages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;
-- SEPARATOR --
ALTER TABLE `menu`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;
-- SEPARATOR --
ALTER TABLE `menus`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=50;
-- SEPARATOR --
ALTER TABLE `modules`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
-- SEPARATOR --
ALTER TABLE `news`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;
-- SEPARATOR --
ALTER TABLE `notifications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
-- SEPARATOR --
ALTER TABLE `orders`
  MODIFY `order_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=256;
-- SEPARATOR --
ALTER TABLE `pages`
  MODIFY `page_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;
-- SEPARATOR --
ALTER TABLE `payments`
  MODIFY `payment_id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `refill_status`
  ADD PRIMARY KEY (`id`);
-- SEPARATOR --
ALTER TABLE `refill_status`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
  -- SEPARATOR --
ALTER TABLE `payments_bonus`
  MODIFY `bonus_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
-- SEPARATOR --
ALTER TABLE `payment_methods`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;
-- SEPARATOR --
ALTER TABLE `proxy`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `referral`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `reset_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `serviceapi_alert`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=133;
-- SEPARATOR --
ALTER TABLE `services`
  MODIFY `service_id` int(11) NOT NULL AUTO_INCREMENT;
-- SEPARATOR --
ALTER TABLE `service_api`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=42;
-- SEPARATOR --
ALTER TABLE `settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
-- SEPARATOR --
ALTER TABLE `tasks`
  MODIFY `task_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;
-- SEPARATOR --
ALTER TABLE `themes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=31;
-- SEPARATOR --
ALTER TABLE `tickets`
  MODIFY `ticket_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=59;
-- SEPARATOR --
ALTER TABLE `ticket_reply`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=111;
-- SEPARATOR --
ALTER TABLE `ticket_subjects`
  MODIFY `subject_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;
-- SEPARATOR --
ALTER TABLE `verify_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=57;